/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.util.EntityUtils;

public class EntityFootballFish
extends ComplexMobAquatic
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> HAS_MALE = SynchedEntityData.m_135353_(EntityFootballFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityFootballFish(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_MALE, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.42).m_22268_(Attributes.f_22277_, 8.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.8, false, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new ComplexMobAquatic.SwimGoal(this, 4));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, false, input -> EntityFootballFish.getEcoLevel(input) < 5));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0) {
                if (this.wantsToBreed() && !this.isMale()) {
                    this.breed();
                }
                if (!this.hasAttachedMale() && this.f_19796_.nextInt(40) == 0 && this.m_20186_() < 42.0) {
                    this.setAttachedMale(true);
                }
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            if (this.f_19796_.nextInt(18) == 0) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_175827_, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.hasAttachedMale() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int i = 0; i <= 16; ++i) {
                BlockState state = this.f_19853_.m_8055_((BlockPos)blockPos.m_122169_(this.m_20185_(), this.m_20186_() + (double)i, this.m_20189_()));
                if (state.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                return false;
            }
            this.m_146762_(this.m_146764_());
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_() && this.hasAttachedMale() && itemstack.m_41720_() == Items.f_42574_) {
            this.m_5496_(SoundEvents.f_12344_, 1.5f, 0.8f);
            this.setAttachedMale(false);
            this.m_6469_(DamageSource.m_19370_((LivingEntity)player), 1.0f);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        if (!this.hasAttachedMale()) {
            this.setAttachedMale(true);
        }
        EntityUtils.dropEggs(this, "egg_football_fish", this.getOffspring());
        return null;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    @Override
    public void updateAttributes() {
        this.setGender(1);
        if (this.f_19796_.nextInt(3) == 0) {
            this.setAttachedMale(true);
        }
    }

    public boolean hasAttachedMale() {
        return (Boolean)this.f_19804_.m_135370_(HAS_MALE);
    }

    private void setAttachedMale(boolean attachedMale) {
        this.f_19804_.m_135381_(HAS_MALE, (Object)attachedMale);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasMale", this.hasAttachedMale());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAttachedMale(compound.m_128471_("hasMale"));
    }
}

